DO $$
BEGIN
IF EXISTS (SELECT 1 FROM pg_type WHERE typname = 'rs_consulta_prod_prcliq') THEN
	DROP TYPE rs_consulta_prod_prcliq cascade;
END IF;
END$$;


CREATE TYPE rs_consulta_prod_prcliq AS
   (codigo integer,
    produto character varying(250),
	estoque integer,
	oferta numeric(12,2),
	tabela numeric(12,2),
	liquido numeric(12,2),
	fabricante character varying,
	prateleira character(50),
    pbm integer,
    vlr_custo numeric(12,2),
	grupo_comissao character varying(100),
	equivalencia character varying
	 );
	
ALTER TYPE rs_consulta_prod_prcliq
  OWNER TO postgres;



/*
DROP FUNCTION public.p_consulta_produto_preco_liq(
    character varying,   -- descricao produto consultar
	integer,			-- tipo de consulta  1 = Produto nome   2 = Principio ativo   3 = Produto nome usual
    integer,			-- cd emp	
	integer,			-- cd filial
	integer,			-- cd conv
	character varying,  -- nro cartao fidelidade
	integer,			-- flag ean
	integer,			-- cd cli
	double precision,	-- qtde
	integer,			-- application
	double precision,	-- id promo
	integer,			-- is receita
	integer,			-- cd forma pgto
	integer,			-- cd vend
	integer				-- cd parceiro
	)
*/

CREATE OR REPLACE FUNCTION public.p_consulta_produto_preco_liq(
	character varying,  -- descricao produto consultar
	integer,			-- tipo de consulta  1 = Produto nome   2 = Principio ativo   3 = Produto nome usual
    integer,			-- cd emp	
	integer,			-- cd filial
	integer,			-- cd conv
	character varying,  -- nro cartao fidelidade
	integer,			-- flag ean
	integer,			-- cd cli
	double precision,	-- qtde
	integer,			-- application
	double precision,	-- id promo
	integer,			-- is receita
	integer,			-- cd forma pgto
	integer,			-- cd vend
	integer				-- cd parceiro
	)
    RETURNS SETOF rs_consulta_prod_prcliq 
    LANGUAGE 'plpgsql'

    COST 10
    VOLATILE 
    ROWS 1000
AS $BODY$
DECLARE
		in_desc_prod		ALIAS FOR $1;
		in_tp_consulta		ALIAS for $2;
		in_cd_emp			ALIAS for $3;
		in_cd_filial		ALIAS for $4;
		in_cd_conv			ALIAS for $5;
		in_nr_cartao_fidel	ALIAS for $6;
		in_ean		  		ALIAS for $7;
		in_cd_cli		 	ALIAS for $8;
		in_qtde_prod		ALIAS for $9;
		in_application		ALIAS for $10;
		in_id_promo			ALIAS for $11;
		in_is_receita		ALIAS for $12;
		in_cd_frm_pgto		ALIAS for $13;
		in_cd_vend			ALIAS for $14;
		in_cd_parceiro		ALIAS for $15;
		var_cd_prod           double precision;
BEGIN

/*
select * from p_consulta_produto_preco_liq('PARACETAMOL', 1, 1, 18, 0, '0', 0, 0, 1, 0, 0, 0, 1, 0, 0)
select * from p_consulta_produto_preco_liq('PARACETAMOL 750', 2, 1, 18, 0, '0', 0, 0, 1, 0, 0, 0, 1, 0, 0)
*/ 

	BEGIN
		DROP TABLE temp_cods_produto;
		EXCEPTION WHEN OTHERS THEN
	END;

	BEGIN
		CREATE TEMPORARY TABLE temp_cods_produto
		(   -- valores de consulta unica
			cd_prod double precision	
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE temp_cods_produto; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.	
	END;
	
	
	BEGIN
		DROP TABLE temp_rs_produto_pool;
		EXCEPTION WHEN OTHERS THEN
	END;

	BEGIN
		CREATE TEMPORARY TABLE temp_rs_produto_pool
		(
			versao character varying(16),
			cd_emp integer,
			cd_filial integer,
			cd_prod integer,
			ds_prod character varying(100),
			nm_fabric character varying(100),
			vlr_tabela numeric(14,2),
			vlr_oferta numeric(14,2),
			qtde_ponto_fidel numeric(14,2),
			ctr_pmc integer,
			flag_verba_descon integer,
			flag_requer_receit integer,
			flag_alterar_preco integer,
			prod_uso_cont integer,
			tp_prod integer,
			vlr_custo numeric(14,2),
			cd_grp integer,
			qtd_ponto_venda double precision,
			lmt_prod_ponto_venda double precision,
			apres_qt_vd integer,
			qtde_estoque numeric(14,4),
			ds_tipo_receita character varying(100),
			ds_cor_receita character varying(100),
			perc_desc_limite numeric(14,4),
			cd_trib_fc character varying(3),
			perc_icms_n_cont_esta double precision,
			perc_red_vd double precision,
			libera_vd_conv integer,
			qtde_prod_max_conv integer,
			perc_desc_fix integer,
			tp_desconto integer,
			vlr_economia numeric(14,2),
			ds_desconto character varying(255),
			cd_tbl_desc integer,
			tp_nivel integer,
			perc_desc numeric(14,4),
			maior_perc_desc numeric(14,4),
			produto_controlado integer,
			flag_desconto_ticket_blq integer,
			perc_desc_fidel_max numeric(14,4),
			promo_industria integer,
			perc_desc_aniver numeric(14,4),
			perc_desc_clas numeric(14,4),
			vlr_desc_fabric numeric(14,2),
			campanha integer,
			qtde_prod_campanha integer,
			flag_bloqueia_desconto integer,
			perc_desc_pos_pbm double precision,
			cd_familia integer,
			ncm_prod character varying(50),
			nr_reg_ms character varying(150),
			qtde_limite_venda integer,
			perc_pis numeric(14,4),
			perc_cofins numeric(14,4),
			ds_categoria character varying(200),
			ds_sub_categoria character varying(200),
			unidade_medida character varying(100),
			tp_tbl_desc 		integer,
			dt_fim timestamp without time zone);

		EXCEPTION WHEN OTHERS THEN TRUNCATE TABLE temp_rs_produto_pool; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;


	begin
		INSERT INTO temp_cods_produto
		SELECT cast(P.CD_PROD as double precision) --, P.DS_PROD , p.CD_FILIAL
			FROM EST_PROD  P
			JOIN EST_PROD_CPL  C
			ON C.CD_EMP  = P.CD_EMP
			AND C.CD_FILIAL = in_cd_filial
			AND C.CD_PROD = P.CD_PROD
			JOIN EST_PROD_PRECO  PC
			ON PC.CD_EMP  = C.CD_EMP
			AND PC.CD_FILIAL = C.CD_FILIAL
			AND PC.CD_PROD = C.CD_PROD
			LEFT JOIN est_prod_princ_ativos_est_prod ppa ON ppa.cd_emp = P.cd_emp and ppa.cd_prod = p.cd_prod 
			LEFT JOIN est_prod_princ_ativos pa ON pa.cd_princ_ativos = ppa.cd_princ_ativos
			WHERE P.CD_EMP = 1
			AND P.STS_PROD IN ( 0 , 2 )
			AND C.STS_PROD IN ( 0 , 2 )
			AND PC.VLR_TABELA > 0
			AND P.CD_FILIAL >= 0
         AND C.TP_PROD IN (0,9,10,11)
			AND ( ( in_tp_consulta = 1 and UPPER(P.DS_PROD) LIKE in_desc_prod || '%' )
				OR ( in_tp_consulta = 2 and UPPER(COALESCE(pa.DS_PRINC_ATIVOS,'')) LIKE in_desc_prod || '%' ) 
				OR ( in_tp_consulta = 3 and UPPER(P.DS_USUAL) LIKE in_desc_prod || '%' ) 
				);
	end;

	-----------------PROCESSAMENTO DA PROCEDURE------------------------------------------------

	while exists (  select 1 from temp_cods_produto order by cd_prod limit 1  )  loop

		var_cd_prod = (select cd_prod from temp_cods_produto order by cd_prod  limit 1); 

		insert into temp_rs_produto_pool
		--select * from p_est_prod_descontos(1, in_cd_filial, var_cd_prod, 0, '0', 0, 0, 1, 0, 0, 0, 1, 0, 0);
		select * from p_est_prod_descontos(in_cd_emp, in_cd_filial, var_cd_prod, in_cd_conv, in_nr_cartao_fidel, in_ean
							, in_cd_cli, in_qtde_prod, in_application, in_id_promo, in_is_receita, in_cd_frm_pgto, in_cd_vend, in_cd_parceiro);

		delete from temp_cods_produto
		where cd_prod = var_cd_prod;

	end loop;
		
	return QUERY --select * FROM temp_rs_produto_pool;
		SELECT CAST(EST_PROD.CD_PROD AS INT) AS CÃ³digo
			, EST_PROD.DS_PROD AS Produto
			, CAST(EST_PROD_CPL.QT_EST AS INT) AS Estoque
			, CAST(COALESCE(EST_PROD_PRECO.VLR_OFERTA,0.00) AS Decimal(12,2)) AS Oferta
			, CAST(COALESCE(EST_PROD_PRECO.VLR_TABELA,0.00) AS Decimal(12,2)) AS Tabela
			, CAST( COALESCE(EST_PROD_PRECO.VLR_TABELA,0.00)
					- (COALESCE(EST_PROD_PRECO.VLR_TABELA,0.00)*(t.PERC_DESC/100.00) ) AS Decimal(12,2)) AS Liquido
			, COALESCE(t.NM_FABRIC, '') AS Fabricante
			, ds_prt AS Prateleira
			, COALESCE((SELECT  CD_EMP FROM EST_PROD_RC_CLI_CONV  WHERE EST_PROD.CD_EMP = EST_PROD_RC_CLI_CONV.CD_EMP AND EST_PROD.CD_PROD = EST_PROD_RC_CLI_CONV.CD_PROD  LIMIT 1),0 ) AS PBM
			, CAST(EST_PROD_CPL.VLR_CUSTO AS Decimal(12,2)) AS VLR_CUSTO 
			, CAST( COALESCE(est_grp_comis_pdv.ds_grp ,'NAO INFORMADO') as character varying(100) ) as grupo_comissao
			, CAST( COALESCE( ( SELECT DS_PRINC_ATIVOS 
									FROM EST_PROD_PRINC_ATIVOS_EST_PROD AS EPPAEP 
									INNER JOIN EST_PROD_PRINC_ATIVOS AS EPPA 
										ON EPPAEP.CD_PRINC_ATIVOS = EPPA.CD_PRINC_ATIVOS 
									WHERE EST_PROD.CD_EMP = EPPAEP.CD_EMP AND EST_PROD.CD_PROD = EPPAEP.CD_PROD LIMIT 1 ), '' ) as character varying ) as equivalencia
		FROM temp_rs_produto_pool  t
		INNER JOIN EST_PROD_CPL  ON EST_PROD_CPL.CD_EMP = t.CD_EMP AND EST_PROD_CPL.CD_FILIAL = t.CD_FILIAL AND EST_PROD_CPL.CD_PROD = t.CD_PROD
		INNER JOIN EST_PROD_PRECO ON EST_PROD_CPL.CD_EMP = EST_PROD_PRECO.CD_EMP AND EST_PROD_CPL.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL AND EST_PROD_CPL.CD_PROD = EST_PROD_PRECO.CD_PROD 
		INNER JOIN EST_PROD ON EST_PROD_CPL.CD_EMP = EST_PROD.CD_EMP AND EST_PROD_CPL.CD_PROD = EST_PROD.CD_PROD 
		LEFT JOIN EST_PROD_FABRIC ON EST_PROD.CD_FABRIC = EST_PROD_FABRIC.CD_FABRIC LEFT JOIN est_prod_prt ON est_prod_prt.cd_prt = est_prod_cpl.prat 
		LEFT JOIN EST_PROD_CPL_CAMP_BRINDE ON EST_PROD_CPL_CAMP_BRINDE.CD_PROD = EST_PROD.CD_PROD 
		LEFT JOIN est_prod_princ_ativos_est_prod ON est_prod_cpl.cd_prod = est_prod_princ_ativos_est_prod.cd_prod 
		LEFT JOIN est_prod_princ_ativos ON est_prod_princ_ativos_est_prod.cd_princ_ativos = est_prod_princ_ativos.cd_princ_ativos 
		left join est_grp_comis_pdv_cpl on 
		est_prod_cpl.cd_emp = est_grp_comis_pdv_cpl.cd_emp and
		est_prod_cpl.cd_filial = est_grp_comis_pdv_cpl.cd_filial and 
		est_prod_cpl.cd_prod = est_grp_comis_pdv_cpl.cd_prod 
		left join est_grp_comis_pdv on 
		est_grp_comis_pdv_cpl.cd_emp = est_grp_comis_pdv.cd_emp and 
		est_grp_comis_pdv_cpl.cd_grp = est_grp_comis_pdv.cd_grp 
		WHERE EST_PROD.STS_PROD <> 1  
			AND (EST_PROD.FLAG_VD_CALL_CENTER = 0 OR EST_PROD.FLAG_VD_CALL_CENTER IS NULL) 
			AND EST_PROD_CPL.TP_PROD IN (0,9,10,11)  
			AND EST_PROD_CPL_CAMP_BRINDE.CD_PROD IS NULL
		ORDER BY EST_PROD.DS_PROD;
		
END;

-- fim bloco principal
$BODY$;

ALTER FUNCTION public.p_consulta_produto_preco_liq(character varying, integer, integer, integer, integer, character varying, integer, integer, double precision, integer, double precision, integer, integer, integer, integer)
    OWNER TO postgres;
